IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CF_WSOCA_OR_XML_Datos') 
                   and type = 'FN')
BEGIN
    DROP FUNCTION dbo.CF_WSOCA_OR_XML_Datos
END
GO

CREATE FUNCTION dbo.CF_WSOCA_OR_XML_Datos(@pId_Trans INT, @pItem SMALLINT) 
RETURNS VARCHAR(8000)
AS
BEGIN
/*Variable de Retorno*/
DECLARE @OR_XML_Datos						VARCHAR(8000)
/*FIN Variable de Retorno*/

/*Variables Locales*/
DECLARE @Version							VARCHAR(3)
DECLARE @Nro_Cuenta							VARCHAR(10)

DECLARE @Origen_Calle						VARCHAR(30)
DECLARE @Origen_Calle_Nro					VARCHAR(5)
DECLARE @Origen_Piso_Nro					VARCHAR(2)
DECLARE @Origen_Depto_Nro					VARCHAR(4)
DECLARE @Origen_Cp							VARCHAR(4)
DECLARE @Origen_Localidad_Descrip			VARCHAR(30)
DECLARE @Origen_Provincia_Descrip			VARCHAR(30)
DECLARE @Origen_Contacto					VARCHAR(30)
DECLARE @Origen_email						VARCHAR(100)
DECLARE @Origen_Solicitante					VARCHAR(30)
DECLARE @Origen_Observaciones				VARCHAR(100)
DECLARE @Origen_CentroCosto					VARCHAR(10)
DECLARE @Origen_Id_Franja_Horaria			VARCHAR(1)
DECLARE @Origen_Id_Centro_Imposicion		VARCHAR(3)
DECLARE @Origen_Fecha						VARCHAR(10)

DECLARE @Envio_Id_Operativa					VARCHAR(6)
DECLARE @Envio_NroRemito					VARCHAR(30)

DECLARE @Destino_Apellido					VARCHAR(30)
DECLARE @Destino_Nombre						VARCHAR(30)
DECLARE @Destino_Calle						VARCHAR(30)
DECLARE @Destino_Calle_Nro					VARCHAR(5)
DECLARE @Destino_Piso_Nro					VARCHAR(6)
DECLARE @Destino_Depto_Nro					VARCHAR(4)
DECLARE @Destino_Localidad_Descrip			VARCHAR(30)
DECLARE @Destino_Provincia_Descrip			VARCHAR(30)
DECLARE @Destino_Cp							VARCHAR(4)
DECLARE @Destino_Telefono					VARCHAR(30)
DECLARE @Destino_Email						VARCHAR(100)
DECLARE @Destino_Id_CI						VARCHAR(3)
DECLARE @Destino_Celular					VARCHAR(15)
DECLARE @Destino_Observaciones				VARCHAR(100)

DECLARE @Paquete_Alto						VARCHAR(11)
DECLARE @Paquete_Ancho						VARCHAR(11)
DECLARE @Paquete_Largo						VARCHAR(11)
DECLARE @Paquete_Peso						VARCHAR(11)
DECLARE @Paquete_Valor						VARCHAR(11)
DECLARE @Paquete_Cantidad					VARCHAR(10)

DECLARE @Id_Sucursal						SMALLINT
DECLARE @Sucursal_Domicilio					VARCHAR(30)
DECLARE @Sucursal_Domicilio_Nro				SMALLINT
DECLARE @Sucursal_Cod_Postal				VARCHAR(20)
DECLARE @Sucursal_Id_Localidad				INT
DECLARE @Sucursal_Localidad					VARCHAR(80)
DECLARE @Sucursal_Id_Provincia				CHAR(3)
DECLARE @Sucursal_Provincia					VARCHAR(50)
DECLARE @Sucursal_Mail						VARCHAR(255)

DECLARE @Id_Cliente							INT
DECLARE @Clientes_Apellido					VARCHAR(100)
DECLARE @Clientes_Nombre					VARCHAR(100)
DECLARE @Clientes_Email						VARCHAR(8000)
DECLARE @Clientes_Tel_Movil					VARCHAR(20)

DECLARE @Clientes_Suc_Direccion				VARCHAR(100)
DECLARE @Clientes_Suc_Dir_Entrega_Numero	INT
DECLARE @Clientes_Suc_Dir_Entrega_Piso		VARCHAR(50)
DECLARE @Clientes_Suc_Dir_Entrega_Dto		VARCHAR(50)
DECLARE @Clientes_Suc_Dir_Entrega_Localidad	VARCHAR(50)
DECLARE @Clientes_Suc_Provincia_Descrip		VARCHAR(200)
DECLARE @Clientes_Suc_Dir_Entrega_CP		VARCHAR(8)
DECLARE @Clientes_Suc_Telefono				VARCHAR(300)
DECLARE @Clientes_Suc_Contacto				VARCHAR(100)

DECLARE @Cbtes_Items_Id_Producto			VARCHAR(14)
DECLARE @Cbtes_Items_Cantidad				DECIMAL(15,5)
DECLARE @Cbtes_Items_Precio_Grav			DECIMAL(15,5)

DECLARE @Productos_Alto						DECIMAL(7,2)
DECLARE @Productos_Ancho					DECIMAL(7,2)
DECLARE @Productos_Largo					DECIMAL(7,2)
DECLARE @Productos_Id_Familia				INT
DECLARE @Productos_Peso						DECIMAL(7,2)

DECLARE @Productos_x_Cantidad_Peso			DECIMAL(9,2)
DECLARE @Productos_x_Cantidad_Cotizacion	DECIMAL(9,2)
/*FIN Variables Locales*/

-------------------------------------------------------------------------------------------------------------------------------------------------------------------

/*
EJ:

<?xml version="1.0" encoding="iso-8859-1" standalone="yes"?>
<ROWS>
	<cabecera ver="2.0" nrocuenta="111757/001" />
	<origenes>
		<origen calle="La Rioja" nro="300" piso="" depto="" cp="1215" localidad="CAPITAL FEDERAL" provincia="CAPITAL FEDERAL" contacto="" email="test@oca.com.ar" solicitante="" observaciones="" centrocosto="" idfranjahoraria="1" idcentroimposicionorigen="3" fecha="20211110">
			<envios>
				<envio idoperativa="94584" nroremito="Envio1">
					<destinatario apellido="Fernandez" nombre="Martin" calle="BALCARCE" nro="50" piso="" depto="" localidad="CAPITAL FEDERAL" provincia="CAPITAL FEDERAL" cp="1214" telefono="49569622" email="test@oca.com.ar" idci="0" celular="1121877788" observaciones="Prueba" />
					<paquetes>
						<paquete alto="10" ancho="10" largo="10" peso="1" valor="10" cant="3" />
					</paquetes>
				</envio>
			</envios>
		</origen>
	</origenes>
</ROWS>
*/

-------------------------------------------------------------------------------------------------------------------------------------------------------------------

SELECT
@Id_Sucursal				= ISNULL(Id_Sucursal, 0),
@Id_Cliente					= ISNULL(Id_Cliente, 0)
FROM Cbtes
WHERE
Id_Trans = @pId_Trans

SELECT
@Cbtes_Items_Id_Producto			= ISNULL(Id_Producto, ''),
@Cbtes_Items_Cantidad				= ISNULL(Cantidad, 0),
@Cbtes_Items_Precio_Grav			= ISNULL(Precio_Grav, 0)
FROM Cbtes_Items
WHERE 
Id_Trans = @pId_Trans
AND Item = @pItem

SELECT
@Productos_Alto						= ISNULL(Alto, 0),
@Productos_Ancho					= ISNULL(Ancho, 0),
@Productos_Largo					= ISNULL(Largo, 0),
@Productos_Id_Familia				= ISNULL(Id_Familia, 0),
@Productos_Peso						= ISNULL(Peso, 0)
FROM Productos
WHERE
Id_Producto = @Cbtes_Items_Id_Producto

IF(@Productos_Id_Familia IN (1000/*FLETES*/, 1020/*ADICIONALES LOGISTICA / ENTREGAS*/))
BEGIN
	SET @OR_XML_Datos = ''
	RETURN @OR_XML_Datos
END

SET @Productos_x_Cantidad_Peso		= CAST(SUM(@Productos_Peso * @Cbtes_Items_Cantidad) AS DECIMAL(9, 2))
SET @Productos_x_Cantidad_Cotizacion = CAST(SUM(@Cbtes_Items_Precio_Grav * @Cbtes_Items_Cantidad) AS DECIMAL(9, 2))

SELECT
@Sucursal_Domicilio			= UPPER(LTRIM(RTRIM(ISNULL(Domicilio, '')))),
@Sucursal_Domicilio_Nro		= ISNULL(Domicilio_Nro, 0),
@Sucursal_Cod_Postal		= UPPER(LTRIM(RTRIM(ISNULL(Cod_Postal, '')))),
@Sucursal_Id_Localidad		= ISNULL(Id_Localidad, 0),
@Sucursal_Mail				= LOWER(LTRIM(RTRIM(ISNULL(Mail, ''))))
FROM Empresas_Suc
WHERE
Id_Sucursal = @Id_Sucursal

SELECT
@Sucursal_Localidad			= UPPER(LTRIM(RTRIM(ISNULL(TL.Descripcion, '')))),
@Sucursal_Id_Provincia		= ISNULL(TP.Id_Provincia, ''),
@Sucursal_Provincia			= UPPER(LTRIM(RTRIM(ISNULL(TP.Descripcion, ''))))
FROM Tab_Localidades TL, Tab_Provincias TP
WHERE
ISNULL(TL.Id_Provincia, '') = TP.Id_Provincia
AND TL.Id_Localidad = @Sucursal_Id_Localidad

SELECT
@Clientes_Apellido				= UPPER(LTRIM(RTRIM(ISNULL(Apellido, '')))),
@Clientes_Nombre				= UPPER(LTRIM(RTRIM(ISNULL(Nombre, '')))),
@Clientes_Email					= LOWER(LTRIM(RTRIM(ISNULL(CONVERT(VARCHAR(8000), email), '')))),
@Clientes_Tel_Movil				= LTRIM(RTRIM(ISNULL(Tel_Movil, '')))
FROM Clientes 
WHERE
Id_Cliente = @Id_Cliente

IF(@Clientes_Email NOT LIKE '%@%')
BEGIN
	SET @Clientes_Email = ''
END

SELECT
@Clientes_Suc_Direccion				= UPPER(LTRIM(RTRIM(ISNULL(Direccion, '')))),
@Clientes_Suc_Dir_Entrega_Numero	= ISNULL(Dir_Entrega_Numero, 0),
@Clientes_Suc_Dir_Entrega_Piso		= UPPER(LTRIM(RTRIM(ISNULL(Dir_Entrega_Piso, '')))),
@Clientes_Suc_Dir_Entrega_Dto		= UPPER(LTRIM(RTRIM(ISNULL(Dir_Entrega_Dto, '')))),
@Clientes_Suc_Dir_Entrega_Localidad	= UPPER(LTRIM(RTRIM(ISNULL(Dir_Entrega_Localidad, '')))),
@Clientes_Suc_Provincia_Descrip		= UPPER(LTRIM(RTRIM(ISNULL(Provincia_Descrip, '')))),
@Clientes_Suc_Dir_Entrega_CP		= UPPER(LTRIM(RTRIM(ISNULL(Dir_Entrega_CP, '')))),
@Clientes_Suc_Telefono				= UPPER(LTRIM(RTRIM(ISNULL(Telefono, '')))),
@Clientes_Suc_Contacto				= UPPER(LTRIM(RTRIM(ISNULL(Contacto, ''))))
FROM Clientes_Suc
WHERE
Id_Cliente = @Id_Cliente
AND Nro = 1


--SELECT Alto FROM Productos

-------------------------------------------------------------------------------------------------------------------------------------------------------------------

SET @Version						= '2.0'
SET @Nro_Cuenta						= LTRIM(RTRIM(dbo.CF_xParam('OCAWS_NroCuenta')))

SET @Origen_Calle					= SUBSTRING(@Sucursal_Domicilio, 1, 30)
SET @Origen_Calle_Nro				= CONVERT(VARCHAR(5), @Sucursal_Domicilio_Nro)
SET @Origen_Piso_Nro				= ''
SET @Origen_Depto_Nro				= ''
SET @Origen_Cp						= SUBSTRING(@Sucursal_Cod_Postal, 1, 5)
SET @Origen_Localidad_Descrip		= SUBSTRING(@Sucursal_Localidad, 1, 30)
SET @Origen_Provincia_Descrip		= SUBSTRING(@Sucursal_Provincia, 1, 30)
SET @Origen_Contacto				= ''
SET @Origen_email					= SUBSTRING(@Sucursal_Mail, 1, 100)
SET @Origen_Solicitante				= ''
SET @Origen_Observaciones			= ''
SET @Origen_CentroCosto				= ''	/*Mail 30/11/2021 10:32Hs Daniel Martin Fernandez <mfernandez@oca.com.ar> indico que se puede enviar siempre cero*/
SET @Origen_Id_Franja_Horaria		= LTRIM(RTRIM(dbo.CF_xParam('OCAWS_FranjaHoraria')))
SET @Origen_Id_Centro_Imposicion	= LTRIM(RTRIM(dbo.CF_xParam('OCAWS_CImposic_Orig')))
SET @Origen_Fecha					= RIGHT('0000' + CAST(DATEPART(YEAR, GETDATE()) AS VARCHAR), 4) + RIGHT('00' + CAST(DATEPART(MONTH, GETDATE()) AS VARCHAR), 2) + RIGHT('00' + CAST(DATEPART(DAY, GETDATE()) AS VARCHAR), 2)

SET @Envio_Id_Operativa				= LTRIM(RTRIM(dbo.CF_xParam('OCAWS_Operativa')))
SET @Envio_NroRemito				= LTRIM(RTRIM(dbo.CF_Cbte_Descrip(@pId_Trans)))

SET @Destino_Apellido				= SUBSTRING(@Clientes_Apellido, 1, 30)
SET @Destino_Nombre					= SUBSTRING(@Clientes_Nombre, 1, 30)
SET @Destino_Calle					= SUBSTRING(@Clientes_Suc_Direccion, 1, 30)
SET @Destino_Calle_Nro				= CONVERT(VARCHAR(5), @Clientes_Suc_Dir_Entrega_Numero)
SET @Destino_Piso_Nro				= SUBSTRING(@Clientes_Suc_Dir_Entrega_Piso, 1, 6)
SET @Destino_Depto_Nro				= SUBSTRING(@Clientes_Suc_Dir_Entrega_Dto, 1, 4)
SET @Destino_Localidad_Descrip		= SUBSTRING(@Clientes_Suc_Dir_Entrega_Localidad, 1, 30)
SET @Destino_Provincia_Descrip		= SUBSTRING(@Clientes_Suc_Provincia_Descrip, 1, 30)
SET @Destino_Cp						= SUBSTRING(@Clientes_Suc_Dir_Entrega_CP, 1, 4)
SET @Destino_Telefono				= SUBSTRING(@Clientes_Suc_Telefono, 1, 30)
SET @Destino_Email					= SUBSTRING(@Clientes_Email, 1, 100)
SET @Destino_Id_CI					= '0'
SET @Destino_Celular				= SUBSTRING(@Clientes_Tel_Movil, 1, 15)
SET @Destino_Observaciones			= SUBSTRING(@Clientes_Suc_Contacto, 1, 100)



SET @Paquete_Alto					= CONVERT(VARCHAR(11), @Productos_Alto)
SET @Paquete_Ancho					= CONVERT(VARCHAR(11), @Productos_Ancho)
SET @Paquete_Largo					= CONVERT(VARCHAR(11), @Productos_Largo)
SET @Paquete_Peso					= CONVERT(VARCHAR(11), @Productos_x_Cantidad_Peso)
SET @Paquete_Valor					= CONVERT(VARCHAR(11), @Productos_x_Cantidad_Cotizacion)
SET @Paquete_Cantidad				= REPLACE(CONVERT(VARCHAR(10), @Cbtes_Items_Cantidad), '.00000', '')

-------------------------------------------------------------------------------------------------------------------------------------------------------------------

SET @OR_XML_Datos = ''
SET @OR_XML_Datos = @OR_XML_Datos + '<?xml version="1.0" encoding="iso-8859-1" standalone="yes"?>'
SET @OR_XML_Datos = @OR_XML_Datos + '<ROWS>'
SET @OR_XML_Datos = @OR_XML_Datos + '<cabecera ver="' + @Version + '" nrocuenta="' + @Nro_Cuenta + '" />'
SET @OR_XML_Datos = @OR_XML_Datos + '<origenes>'
SET @OR_XML_Datos = @OR_XML_Datos + '<origen calle="' + @Origen_Calle + '" nro="' + @Origen_Calle_Nro + '" piso="' + @Origen_Piso_Nro + '" depto="' + @Origen_Depto_Nro + '" cp="' + @Origen_Cp +'" localidad="' + @Origen_Localidad_Descrip + '" provincia="' + @Origen_Provincia_Descrip +'" contacto="' + @Origen_Contacto +'" email="' + @Origen_email +'" solicitante="' + @Origen_Solicitante +'" observaciones="' + @Origen_Observaciones + '" centrocosto="' + @Origen_CentroCosto + '" idfranjahoraria="' + @Origen_Id_Franja_Horaria + '" idcentroimposicionorigen="' + @Origen_Id_Centro_Imposicion + '" fecha="' + @Origen_Fecha +'">'
SET @OR_XML_Datos = @OR_XML_Datos + '<envios>'
SET @OR_XML_Datos = @OR_XML_Datos + '<envio idoperativa="' + @Envio_Id_Operativa + '" nroremito="' + @Envio_NroRemito + '">'
SET @OR_XML_Datos = @OR_XML_Datos + '<destinatario apellido="' + @Destino_Apellido +'" nombre="' + @Destino_Nombre + '" calle="' + @Destino_Calle +'" nro="' + @Destino_Calle_Nro +'" piso="' + @Destino_Piso_Nro + '" depto="' +  @Destino_Depto_Nro + '" localidad="' + @Destino_Localidad_Descrip +'" provincia="' + @Destino_Provincia_Descrip +'" cp="' + @Destino_Cp + '" telefono="' + @Destino_Telefono +'" email="' + @Destino_Email +'" idci="' + @Destino_Id_CI + '" celular="' + @Destino_Celular + '" observaciones="'+ @Destino_Observaciones +'" />'
SET @OR_XML_Datos = @OR_XML_Datos + '<paquetes>'
SET @OR_XML_Datos = @OR_XML_Datos + '<paquete alto="' + @Paquete_Alto +'" ancho="' + @Paquete_Ancho + '" largo="' + @Paquete_Largo + '" peso="' + @Paquete_Peso + '" valor="' + @Paquete_Valor +'" cant="' + @Paquete_Cantidad +'" />'
SET @OR_XML_Datos = @OR_XML_Datos + '</paquetes>'
SET @OR_XML_Datos = @OR_XML_Datos + '</envio>'
SET @OR_XML_Datos = @OR_XML_Datos + '</envios>'
SET @OR_XML_Datos = @OR_XML_Datos + '</origen>'
SET @OR_XML_Datos = @OR_XML_Datos + '</origenes>'
SET @OR_XML_Datos = @OR_XML_Datos + '</ROWS>'

-------------------------------------------------------------------------------------------------------------------------------------------------------------------

RETURN ISNULL(@OR_XML_Datos, '')
END

/*
SELECT dbo.CF_WSOCA_OR_XML_Datos(9228826, 1)

Visualizador XML: https://codebeautify.org/xmlviewer
*/